package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyArtSeriesClaimReqDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 11:10
 */
@ApiModel(value = "GalaxyArtSeriesClaimReqDto", description = "NFT系列声明")
@Data
public class GalaxyArtSeriesClaimReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "系列唯一id标识，不超过20个字符")
    @NotBlank(message = "skuId不能为空！")
    @Size(min = 2, max = 20, message = "skuId限制2-20位且不能包含特殊字符")
    private String skuId;

    @ApiModelProperty(position = 1, required = true, value = "作者名，中文+英文(数字或符号为非法输入) 不超过20个字符")
    @NotBlank(message = "author不能为空！")
    @Size(max = 20, message = "中文+英文(数字或符号为非法输入) 不超过20个字符")
    private String author;

    @ApiModelProperty(position = 1, required = true, value = "nft名字(sku名称)，中英文数字均可，不超过100个字符")
    @NotBlank(message = "nft名字不能为空！")
    @Size(max = 100, message = "nft名字不能超过100个字符")
    private String nftName;

    @ApiModelProperty(position = 1, required = true, value = "nftUrl(对应素材上传中materialAccessUrl)，不超过500个字符")
    @NotBlank(message = "url不能为空！")
    @Size(max = 500, message = "nftUrl，不超过500个字符")
    private String nftUrl;

    @ApiModelProperty(position = 1, required = true, value = "预览图url，不超过500个字符(至信链浏览器展示预览图尺寸为290*290，请上传比例为1:1的图片)")
    @NotBlank(message = "预览图url不能为空！")
    @Size(max = 500, message = "预览图url，不超过500个字符")
    private String displayUrl;

    @ApiModelProperty(position = 1, required = true, value = "nft简介，300个字符以内")
    @NotBlank(message = "描述不能为空！")
    @Size(max = 300, message = "nft简介，300个字符以内")
    private String desc;

    @ApiModelProperty(position = 1, required = false, value = "标签，文创，游戏，动漫，30个字符以内")
    @Size(max = 20, message = "标签，文创，游戏，动漫，20个字符以内")
    private String flag;

    @ApiModelProperty(position = 1, required = true, value = "sku价格，金额必须是数字格式，例：211.23 后续不可修改")
    @NotBlank(message = "购买价格不能为空！")
    @Digits(integer = 10,fraction = 2,message = "金额必须是数字格式")
    private String sellCount;

    @ApiModelProperty(position = 1, required = true, value = "系列nft发行总量(对应sku库存)")
    @NotBlank(message = "系列nft发行总量(对应sku库存)！")
    @Digits(integer = 10,fraction = 0,message = "系列nft发行总量")
    private Long totalCount;

    @ApiModelProperty(position = 1, required = true, value = "系列封面url，不超过500个字符(至信链浏览器展示预览图尺寸为290*290，请上传比例为1:1的图片)")
    @NotBlank(message = "预览图url不能为空！")
    @Size(max = 500, message = "预览图url，不超过500个字符")
    private String coverUrl;

    @ApiModelProperty(position = 1, required = true, value = "系列描述信息，不超过500个字符")
    @NotBlank(message = "预览图url不能为空！")
    @Size(max = 500, message = "预览图url，不超过500个字符")
    private String seriesDesc;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyArtSeriesClaimReqDto obj = new GalaxyArtSeriesClaimReqDto();

    public static GalaxyArtSeriesClaimReqDto getNew() {
        try {
            return (GalaxyArtSeriesClaimReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyArtSeriesClaimReqDto();
        }
    }
}
