package com.liquidnet.common.third.zxlnft.dto.nft;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: SeriesReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:44
 */
@Data
public class Nft032SeriesResp implements Serializable {
    private SeriesInfo seriesInfo;

    @Data
    public class SeriesInfo{
        /**
         * 系列ID
         */
        private String seriesId;
        /**
         * 系列名字
         */
        private String name;
        /**
         * 创建者地址
         */
        private String creatorAddr;
        /**
         * 总数
         */
        private Long totalCount;
        /**
         * 系列下的nftId后缀,是否从0开始，true就是从0开始，默认为false，从1开始
         */
        private boolean seriesBeginFromZero;
        /**
         * 当前个数（当前已发行此系列的个数）
         */
        private Long crtCount;
        /**
         * 封面图
         */
        private String coverUrl;
        /**
         * 描述
         */
        private String desc;
        /**
         * 创建时间戳
         */
        private Long createTimeStamp;
    }

    private static final Nft032SeriesResp obj = new Nft032SeriesResp();
    public static Nft032SeriesResp getNew() {
        try {
            return (Nft032SeriesResp) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft032SeriesResp();
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }
}
