package com.liquidnet.service.galaxy.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.aop.annotation.ControllerLog;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.service.IGalaxyArtworkService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT上传，系列声明
 * @class: GalaxyArtworkController
 * @Package com.liquidnet.service.galaxy.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 13:59
 */
@Api(tags = "NFT艺术品相关")
@RestController
@RequestMapping("artwork")
@Validated
@Slf4j
public class GalaxyArtworkController {
    @Autowired
    private IGalaxyArtworkService galaxyArtworkService;

    @ControllerLog(description = "NFT图片风险检测")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT图片风险检测")
    @PostMapping(value = {"nftImageCheck"})
    public ResponseDto<GalaxyNftImageRespDto> nftImageCheck(@Valid @RequestBody GalaxyNftImageReqDto reqDto) {
        return galaxyArtworkService.nftImageCheck(reqDto);
    }

    @ControllerLog(description = "NFT素材上传")
    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "NFT素材上传")
    @PostMapping(value = {"nftUpload"})
    public ResponseDto<GalaxyNftUploadRespDto> nftUpload(@Valid @RequestBody GalaxyNftUploadReqDto reqDto) {
        return galaxyArtworkService.nftUpload(reqDto);
    }

    @ControllerLog(description = "NFT系列声明")
    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "NFT系列声明")
    @PostMapping(value = {"seriesClaim"})
    public ResponseDto<GalaxyArtSeriesClaimRespDto> seriesClaim(@Valid @RequestBody GalaxyArtSeriesClaimReqDto reqDto) {
        return galaxyArtworkService.seriesClaim(reqDto);
    }

//    @ControllerLog(description = "NFT素材上传（form-data文件提交）")
//    @ApiOperationSupport(order = 1)
//    @ApiOperation(value = "NFT素材上传")
//    @PostMapping(value = {"nftFileUpload"})
//    public ResponseDto<GalaxyNftUploadRespDto> nftFileUpload(@RequestParam("file") MultipartFile file) {
//        if (file.isEmpty()) {
//            return ResponseDto.failure("上传失败，请选择文件");
//        }
//        GalaxyNftUploadReqDto reqDto = GalaxyNftUploadReqDto.getNew();
//        reqDto.setImageUrl("");
//        try {
//            File upFile = file.getResource().getFile();
//            reqDto.setFile(upFile);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//        reqDto.setSeriesName("");
//        return galaxyArtworkService.nftUpload(reqDto);
//    }
}
