package com.liquidnet.service.galaxy.router.strategy.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterHandler;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinArtworkBiz;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinPublishBiz;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinUserBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayChannelStrategyAlipayImpl
 * @Package com.liquidnet.service.dragon.channel.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/13 13:06
 */
@Slf4j
@Component
@StrategyGalaxyRouterHandler(GalaxyConstant.RouterTypeEnum.ZXINCHAIN)
public class GalaxyRouterStrategyZxlImpl extends AbstractGalaxyRouterStrategyImpl {
    @Autowired
    private ZxinUserBiz zxinUserBiz;

    @Autowired
    private ZxinArtworkBiz zxinArtworkBiz;

    @Autowired
    private ZxinPublishBiz zxinPublishBiz;

    @Override
    public ResponseDto<GalaxyUserRegisterRespDto> userRegister(GalaxyUserRegisterReqDto reqDto) {
        return zxinUserBiz.userRegister(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftImageRespDto> nftImageCheck(GalaxyNftImageReqDto reqDto) {
        return zxinArtworkBiz.nftImageCheck(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftUploadRespDto> nftUpload(GalaxyNftUploadReqDto reqDto) {
        return zxinArtworkBiz.nftUpload(reqDto);
    }

    @Override
    public ResponseDto<GalaxyArtSeriesClaimRespDto> seriesClaim(GalaxyArtSeriesClaimReqDto reqDto) {
        return zxinArtworkBiz.seriesClaim(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(GalaxyNftBuyReqDto reqDto) {
        return zxinPublishBiz.nftBuy(reqDto);
    }
}
