package com.liquidnet.service.galaxy.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.GalaxyRouterStrategyContext;
import com.liquidnet.service.galaxy.service.IGalaxyArtworkService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyArtworkServiceImpl
 * @Package com.liquidnet.service.galaxy.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/12 00:14
 */
@Slf4j
@Service
public class GalaxyArtworkServiceImpl implements IGalaxyArtworkService {
    @Autowired
    private GalaxyRouterStrategyContext galaxyRouterStrategyContext;

    @Override
    public ResponseDto<GalaxyNftImageRespDto> nftImageCheck(GalaxyNftImageReqDto reqDto) {
        return galaxyRouterStrategyContext.getStrategy(reqDto.getRouteType()).nftImageCheck(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftUploadRespDto> nftUpload(GalaxyNftUploadReqDto reqDto) {
        return galaxyRouterStrategyContext.getStrategy(reqDto.getRouteType()).nftUpload(reqDto);
    }

    @Override
    public ResponseDto<GalaxyArtSeriesClaimRespDto> seriesClaim(GalaxyArtSeriesClaimReqDto reqDto) {
        return galaxyRouterStrategyContext.getStrategy(reqDto.getRouteType()).seriesClaim(reqDto);
    }
}
