package com.liquidnet.service.merchant.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.middle.KylinBuyNoticeVo;
import com.liquidnet.service.kylin.service.partner.IKylinBuyNoticePartnerService;
import com.liquidnet.service.merchant.util.InnerUtils;
import com.liquidnet.service.merchant.util.MongoMerchantUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 购票须知表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-18
 */
@Api(tags = "第三方-购票须知", position = 1004)
@RestController
@RequestMapping("partner/buyNotice")
public class KylinBuyNoticeParnterController {

    @Autowired
    private IKylinBuyNoticePartnerService buyNoticePartnerService;
    @Autowired
    InnerUtils innerUtils;

    @GetMapping(value = "")
    @ApiOperation(value = "购票须知列表", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<List<KylinBuyNoticeVo>> getBuyNotice() {
        PageInfo<KylinBuyNoticeVo> result = buyNoticePartnerService.getBuyNotice();
        if (null == result) {
            return ResponseDto.failure("查询失败");
        } else {
            return ResponseDto.success(result.getList());
        }
    }

    @GetMapping(value = "string")
    @ApiOperation(value = "购票须知列表String", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> getBuyNoticeJsonString(@RequestParam("buyNoticeId") String buyNoticeId) {
        return ResponseDto.success(innerUtils.getBuyNoticeJsonString(Arrays.asList(buyNoticeId.split(","))));
    }

}
