package com.liquidnet.service.merchant.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.middle.KylinBuyNoticeVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.util.List;

@Component
public class InnerUtils {

//    @Value("${liquidnet.service.platform.url}")
    private String platform="http://127.0.0.1:9003";

    public List<KylinBuyNoticeVo> getBuyNotice() {
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String resultData = HttpUtil.get(platform + "/platform/partner/buyNotice", null, header);
        ResponseDto<List<KylinBuyNoticeVo>> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<List<KylinBuyNoticeVo>>>() {
        });
        return innerReturnVo.getData();
    }

    public String getBuyNoticeJsonString(List<String> buyNoticeId) {
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        String resultData = HttpUtil.get(platform + "/platform/partner/buyNotice/string?buyNoticeId="+ StringUtils.join(buyNoticeId,","), null, header);
        ResponseDto<String> innerReturnVo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<String>>() {
        });
        return innerReturnVo.getData();
    }

}
