package com.liquidnet.service.merchant.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.merchant.dto.param.MerchantSponsorApplyParam;
import com.liquidnet.service.merchant.service.IMerchantSponsorsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * <p>
 * 主办 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-01
 */
@ApiSupport(order = 10011)
@Api(tags = "主办")
@Slf4j
@Validated
@RestController
@RequestMapping("sponsors")
public class MerchantSponsorsController {

    @Autowired
    IMerchantSponsorsService merchantSponsorsService;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "申请主办")
    @PostMapping("apply")
    public ResponseDto<Object> apply(@Valid @RequestBody MerchantSponsorApplyParam parameter) {
        String currentUid = CurrentUtil.getCurrentUid();

        return ResponseDto.success(merchantSponsorsService.apply(currentUid, parameter));
    }

    @ApiOperationSupport(order = 12)
    @ApiOperation(value = "申请主办驳回后删除")
    @PostMapping("apply/del")
    public ResponseDto<Object> applyDel(@RequestParam(required = true) String sponsorApplyId) {
        String currentUid = CurrentUtil.getCurrentUid();

        merchantSponsorsService.applyDel(currentUid, sponsorApplyId);

        return ResponseDto.success();
    }

}
