package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 修改未发行的数字资产
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper003AlterAssetReqDto {
    /**
     * 资产id
     */
    private Long assetId;
    /**
     * 助记词
     */
    private String mnemonic;
    /**
     * 资产碎片数量，小于1和大于200000代表不做库存限制
     */
    private Integer amount;
    /**
     * 藏品显示售卖价格，单位为分
     */
    private Long price;

    /**
     * (可选)业务侧用户标记，必要时请安全处理后设置
     */
    private Long userId;

    /**
     * (可选)要存证的资产文件sm3散列值，如有多个文件逐个计算hash值后合并计算最终hash值
     */
    private String fileHash;

    /**
     * 资产分类。1：艺术品 2：收藏品 3：门票 4：酒店
     */
    private Integer assetCate;
    /**
     * 资产名称，小于30个字节
     */
    private String title;
    /**
     * 资产缩略图。bos上传的图片，格式支持：”jpg”, “jpeg”, “png”, “bmp”, “webp”, “heic”。参数格式bos_v1://{bucket}/{object}/{width}_{height}
     */
    private String thumb;
    /**
     * 短文字描述，小于300个字节
     */
    private String shortDesc;
    /**
     * (可选)资产详情介绍长图。bos上传的图片，格式支持：”jpg”, “jpeg”, “png”, “bmp”, “webp”, “heic”。参数格式bos_v1://{bucket}/{object}/{width}_{height}
     */
    private String imgDesc;
    /**
     * 资产原始文件。比如图片，图片本身就是资产。格式bos_v1://{bucket}/{object} ，文件大小<10M。文件名采用文件md5值，为了正常展现，需要正确携带文件后缀
     */
    private String assetUrl;
    /**
     * (可选)长文字描述，小于1200个字节
     */
    private String longDesc;
    /**
     * (可选)资产额外描述信息json字符串。比如标签
     */
    private String assetExt;
    /**
     * (可选)资产组id。用于关联业务层酒店/店铺id
     */
    private Long groupId;

    private static final Xuper003AlterAssetReqDto obj = new Xuper003AlterAssetReqDto();
    public static Xuper003AlterAssetReqDto getNew() {
        try {
            return (Xuper003AlterAssetReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper003AlterAssetReqDto();
        }
    }
}
