package com.liquidnet.service.dragon.channel.alipay.strategy.impl;

import com.liquidnet.service.dragon.channel.alipay.biz.AlipayBiz;
import com.liquidnet.service.dragon.channel.alipay.req.AlipayTradePayReq;
import com.liquidnet.service.dragon.channel.alipay.strategy.annotation.StrategyAlipayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayStrategyWapImpl
 * @Package com.liquidnet.service.dragon.channel.alipay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:34
 */
@Slf4j
@Service
@StrategyAlipayHandler(DragonConstant.DeviceFromEnum.MICROPAY)
public class AlipayStrategyMicropayImpl extends AbstractAlipayStrategy {
    @Value("${liquidnet.dragon.alipay.gataway-url}")
    private String alipayGatewayUrl;

    @Value("${liquidnet.dragon.url}")
    private String notifyUrl;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private AlipayBiz alipayBiz;

    @Override
    protected Map<String, Object> executePay(AlipayTradePayReq alipayTradePayReq) {
        return alipayBiz.tradeMicroPay(alipayTradePayReq);
    }

    protected void setProductCode() {
        this.productCode = "QUICK_WAP_PAY";
    }

    @Override
    protected String getNotifyUrl() {
//        notifyUrl = "/notify/wap/alipay/1";
        return notifyUrl + "/notify/alipay/wap";
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, Map<String, Object> respResult) {
       // payBaseRespDto.getPayData().setRedirectUrl(alipayGatewayUrl + "?" + respResult.get("body"));
        //判断是否成功
        if(respResult.get("code")!=null&&!respResult.get("code").equals("10000")){
            payBaseRespDto.setMsg(respResult.get("subMsg")==null?"":respResult.get("subMsg").toString());
        }
        return payBaseRespDto;
    }
}
