package com.liquidnet.service.goblin.service.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;

import java.math.BigInteger;

/**
 * <p>
 * 预约表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
public interface IGoblinGoodsAnticipateMgService {

    /**
     * 获取预约
     * @param goodsAnticipateValueParam 查询条件
     * @return 分页查询
     */
    ResponseDto<PageInfo<GoblinGoodsAnticipateValueVo>> list(GoblinGoodsAnticipateValueParam goodsAnticipateValueParam);

    /**
     * 新增预约
     * @param goodsAnticipateAddParam 新增
     * @return 1
     */
    ResponseDto<String> add(GoblinGoodsAnticipateAddParam goodsAnticipateAddParam);

    /**
     * 修改预约人数
     * @param antId antId
     * @param people 修改人数
     * @return Boolean
     */
    ResponseDto<Boolean> updatePeople(String antId, BigInteger people);

    /**
     * 删除预约
     * @param skuId skuId
     * @return Boolean
     */
    ResponseDto<Boolean> delete(String skuId);

    /**
     * 更具sku获取信息
     * @param skuId skuId
     * @param hasHead 1
     * @return 预约关联sku和spu表
     */
    AnticipateValueVo getAnticipateValueBySkuId(String skuId,int hasHead);
}
