package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 22.生成素材上传临时密钥接口
 * @class: UploadSecretReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:37
 */
@Data
public class Nft022UploadSecretReqDto implements Serializable {
    /**
     * 系列名
     */
    //@Null
    private String seriesName;
    /**
     * 10位时间戳，秒为单位，5分钟内有效
     */
    private String timestamp;
    /**
     * 平台公钥
     */
    private String pubKey;
    /**
     * 1、系列不为空：签名"tiemstamp_seriesName_userPubKey"
     * 2、系列为空：签名"tiemstamp_userPubKey"
     */
    private String pubSignedData;
    /**
     * 发行人公钥
     */
    private String userPubKey;
    /**
     * 1、系列不为空：签名"tiemstamp_seriesName"
     * 2、系列为空：签名"tiemstamp"
     */
    private String userSignedData;

    private static final Nft022UploadSecretReqDto obj = new Nft022UploadSecretReqDto();
    private static final long serialVersionUID = 5550839849579734439L;

    public static Nft022UploadSecretReqDto getNew() {
        try {
            return (Nft022UploadSecretReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft022UploadSecretReqDto();
        }
    }
}
