package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 发行+购买结果查询
 * @class: GalaxyNftPublishResultQueryReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/28 11:22
 */
@ApiModel(value = "GalaxyNftPublishResultQueryReqDto", description = "NFT发行结果查询")
@Data
public class GalaxyNftPublishAndBuyResultBatchQueryReqDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    @NotBlank(message = "用户ID不能为空！")
    @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
    private String userId;

    /**
     * nftOrderPayId
     */
    @ApiModelProperty(position = 1, required = true, value = "nft订单支付idList不能为空")
    @NotNull(message = "nft订单支付idList不能为空")
    private List<RouterOrderInfo> routerOrderInfoList;


    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishAndBuyResultBatchQueryReqDto obj = new GalaxyNftPublishAndBuyResultBatchQueryReqDto();

    public static GalaxyNftPublishAndBuyResultBatchQueryReqDto getNew() {
        try {
            return (GalaxyNftPublishAndBuyResultBatchQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishAndBuyResultBatchQueryReqDto();
        }
    }
    @Data
    public static class RouterOrderInfo{
        @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
        @NotBlank(message = "用户ID不能为空！")
        @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
        private String userId;
        /**
         * 路由类型(至信链zxinchain、以太坊eth)
         */
        @ApiModelProperty(position = 1, required = true, value = "路由类型(至信链zxinchain、以太坊eth)")
        @NotBlank(message = "路由类型不能为空！")
        private String routerType;

        @ApiModelProperty(position = 1, required = true, value = "nft订单支付id")
        private List<String> nftOrderPayIdList;

    }
}
