package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * YB报名表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-07-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetYbEnroll implements Serializable {

    private static final long serialVersionUID = -2081186417971841992L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * enroll_id
     */
    private String enrollId;

    /**
     * 音乐人id
     */
    private Integer musicianId;

    /**
     * 联系电话
     */
    private String contactTell;

    /**
     * 联系微信
     */
    private String contactWechat;

    /**
     * 乐队名称
     */
    private String nickname;

    /**
     * 风格（必填）（可勾选 摇滚，世界音乐，国风，民谣，电子，其他）
     */
    private String style;

    /**
     * 乐队照片（必填，3MB以内）
     */
    private String imgUrl;

    /**
     * 音频文件上传  （必填，20MB以内）
     */
    private String audioUrl;

    /**
     * 院校（非必填）（可勾选 川音，现音，其他）
     */
    private String universities;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
