package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsSkuArAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsSkuArFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsSkuArListVo;

import java.util.List;

public interface IGoblinStoreMgtGoodsSkuExtraService {

    /**
     * 商品管理:藏品AR:列表
     *
     * @param mgtGoodsSkuExtraFilterParam GoblinStoreMgtGoodsSkuExtraFilterParam
     * @return PagedResult<GoblinStoreMgtGoodsSkuArListVo>
     */
    PagedResult<GoblinStoreMgtGoodsSkuArListVo> skuArList(GoblinStoreMgtGoodsSkuArFilterParam mgtGoodsSkuExtraFilterParam);

    /**
     * 商品管理:藏品AR:添加编辑
     *
     * @param uid                   UID
     * @param mgtGoodsSkuArAddParam GoblinStoreMgtGoodsSkuArAddParam
     * @param editFlg               true-编辑|false-添加
     * @return boolean
     */
    boolean skuArAddEdit(String uid, GoblinStoreMgtGoodsSkuArAddParam mgtGoodsSkuArAddParam, boolean editFlg);

    /**
     * 商品管理:藏品AR:删除
     *
     * @param uid       UID
     * @param skuIdList List<单品ID>
     * @return boolean
     */
    boolean skuArDel(String uid, List<String> skuIdList);
}
