package com.liquidnet.service.kylin.service.admin;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.kylin.dao.RoadShowAdminListDao;
import com.liquidnet.service.kylin.dto.param.CreateRoadShowParam;
import com.liquidnet.service.kylin.dto.vo.admin.KylinRoadShowAdminVo;
import com.liquidnet.service.kylin.entity.KylinRoadShows;

/**
 * <p>
 * 巡演 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
public interface IKylinRoadShowsAdminService extends IService<KylinRoadShows> {

    /**
     * 创建巡演
     * @param createRoadShowParam 创建巡演参数
     * @return 巡演id
     */
    String createRoadShow(CreateRoadShowParam createRoadShowParam);

    /**
     * 修改巡演
     * @param createRoadShowParam 修改巡演参数
     * @return 巡演id
     */
    boolean updateRoadShow(CreateRoadShowParam createRoadShowParam);

    /**
     * 删除巡演 (修改巡演上下线关系)
     * @param roadShowId 巡演id
     * @param status 状态 0停用 1启用
     * @return boolean
     */
    boolean deleteRoadShow(String roadShowId, int status);

    /**
     * 巡演详情
     * @param roadShowId 巡演id
     * @return 巡演数据
     */
    KylinRoadShowAdminVo detailsRoadShow(String roadShowId);

    /**
     * 巡演列表
     * @param title 巡演名称
     * @param page 页数
     * @param size 数量
     * @return 分页 sql 数据
     */
    PageInfo<RoadShowAdminListDao> listRoadShow(String title, int page, int size);


}
