package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinListDetailsVo;
import com.liquidnet.service.goblin.dto.vo.GoblinListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinMixDetailsVo;
import com.liquidnet.service.goblin.dto.vo.GoblinMixManageListVo;
import com.liquidnet.service.goblin.param.GoblinListCreateParam;
import com.liquidnet.service.goblin.param.GoblinListUpdateParam;
import com.liquidnet.service.goblin.param.GoblinMixDetailsParam;
import com.liquidnet.service.goblin.param.GoblinMixUpdateParam;
import com.liquidnet.service.goblin.service.manage.IGoblinListService;
import com.liquidnet.service.goblin.service.manage.IGoblinMixService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * 正在下单活动管理
 */
@ApiSupport(order = 149201)
@Slf4j
@RestController
@Api(tags = "活动-混合售")
@RequestMapping("store/mix")
public class GoblinMixController {

    @Autowired
    IGoblinMixService goblinMixService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "name", value = "活动名称"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数"),

    })
    @GetMapping("list")
    public ResponseDto<PageInfo<GoblinMixManageListVo>> list(@RequestParam(value = "name", required = false) String name,
                                                             @RequestParam Integer page) {
        return goblinMixService.mixList(name, page);
    }

    @ApiOperation(value = "详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mixId", value = "名单id"),
    })
    @GetMapping("details")
    public ResponseDto<GoblinMixDetailsVo> details(@NotBlank(message = "集合ID不能为空") @RequestParam String mixId) {
        return goblinMixService.mixDetails(mixId);
    }

    @ApiOperation(value = "创建")
    @PostMapping("create")
    public ResponseDto<String> create(@RequestBody GoblinMixDetailsParam param) {
        return goblinMixService.mixInsert(param);
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "修改")
    @PutMapping("change")
    public ResponseDto<Boolean> update(@RequestBody GoblinMixUpdateParam param) {
        return goblinMixService.mixUpdate(param);
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "修改上线状态")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mixId", value = "活动id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "status", value = "状态[6-上线|7-下线]"),
    })
    @PostMapping("status")
    public ResponseDto<Boolean> update(@NotBlank(message = "活动ID不能为空") @RequestParam String mixId,
                                       @NotBlank(message = "状态不能为空") @RequestParam Integer status) {
        return goblinMixService.mixLine(mixId, status);
    }

}
