package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.alibaba.excel.support.ExcelTypeEnum;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.zhengzai.smile.dto.SaleDataVo;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

/**
 * @author TT
 */
@Api(tags = "演出管理")
@Controller
@RequestMapping("/smile/show/base")
@Slf4j
public class SmileShowBaseController extends BaseController {

    private String prefix = "zhengzai/smile";

    @Autowired
    ISmileShowService smileShowService;

    @GetMapping("/saleData/{performancesId}")
    @ApiOperation("销售数据")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "performancesId", value = "演出ID")
    })
    public String saleData(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        SaleDataVo saleDataVo = smileShowService.saleData(performancesId);
        mmap.put("saleDataVo", saleDataVo);
        return prefix + "/smileTickets/saleData";
    }

    @GetMapping("/export")
    @ApiOperation("单个演出销售列表导出")
    @ResponseBody
    public void export(String perId, HttpServletResponse response) {
        ServletOutputStream servletOutputStream = null;
        try {
            response.setHeader(HttpHeaders.CONTENT_DISPOSITION, "attachment;filename="
                    .concat(new String(("演出id_" + perId + "_" + DateUtil.getNowTime() + "代理数据").getBytes("gb2312"), StandardCharsets.ISO_8859_1)).concat(ExcelTypeEnum.XLSX.getValue()));
            response.setContentType(MediaType.MULTIPART_FORM_DATA_VALUE);
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            servletOutputStream = response.getOutputStream();
            //数据查询
/*
            SaleDataVo saleDataVo = smileShowService.saleData(performancesId);
            List<UserDataExcel> rowsToExcels = new ArrayList<>();
            saleDataVo.getUserDataList().forEach(userData -> rowsToExcels.add(UserDataExcel.getNew().copy(userData)));
            EasyExcel.write(servletOutputStream,UserDataExcel.class).sheet(saleDataVo.getTitle() + "演出销售列表导出").doWrite(rowsToExcels);

*/
            smileShowService.exportData(servletOutputStream,perId);

        } catch (IOException e) {
            log.error("单个演出销售列表导出异常[performancesId={},ex.msg={}]", perId, e.getLocalizedMessage());
        } finally {
            if (null != servletOutputStream) {
                try {
                    servletOutputStream.close();
                } catch (Exception ignored) {
                }
            }
        }
    }

    /*@GetMapping("/saleDataTest/{performancesId}")
    @ApiOperation("销售数据Test")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "performancesId", value = "演出ID")
    })
    @ResponseBody
    public AjaxResult saleDataTest(@PathVariable("performancesId") String performancesId) {
        SaleDataVo saleDataVo = smileShowService.saleData(performancesId);
        return AjaxResult.success(saleDataVo);
    }*/

}
