package com.liquidnet.service.base;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.ServletUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class UserPathDto implements Serializable {

    private static UserPathDto instance = new UserPathDto();

    private static final long serialVersionUID = -4153353929914805750L;
    private String tag;
    private String uid;
    private String token;
    private String time;//yyyyMMddHHmmssSSS
    private String interfaceName;
    private String params;
    private String result;
    private String ip;
    private String userAgent;

    private UserPathDto() {}

    private static UserPathDto getInstance() {
        return instance;
    }

    public static String setData(String interfaceName, Object params, Object result) {
        instance.tag = "ANJIABIN";
        instance.uid = CurrentUtil.getCurrentUid() == null ? "UID" : CurrentUtil.getCurrentUid();
        instance.token = CurrentUtil.getToken() == null ? "TOKEN" : CurrentUtil.getToken();
        instance.time = DateUtil.Formatter.yyyyMMddHHmmssSSSUnTrim.format(LocalDateTime.now());
        instance.interfaceName = interfaceName;
        instance.params = params.toString().equals("") ? "NanParams" : params.toString();
        instance.result = result.toString().equals("") ? "NanResults" : result.toString();;
        instance.ip = CurrentUtil.getCliIpAddr();
        instance.userAgent = ServletUtils.getRequest().getHeader("User-Agent");
        return JsonUtils.toJson(instance);

    }
}
