package com.liquidnet.service.candy.dto.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;

@ApiModel(value = "CandyCouponRuleBuildParam", description = "添加券规则入参")
public class CandyCouponRuleBuildParam {
    @Pattern(regexp = "\\b(100|90|91|92|80|81)\\b", message = "适用范围无效")
    @ApiModelProperty(required = true, value = "适用范围[101-音乐节｜102-小型演出(livehouse演出) ｜103-巡演｜100-全场｜90-演出｜91-场次｜92-票｜80-商品｜81-款式]", allowableValues = "100,90,91,92,80,81")
    private Integer useScope;
    @ApiModelProperty(required = true, value = "适用名称", allowableValues = "适用名称")
    private String busiName;
    @ApiModelProperty(required = false, value = "适用ID", allowableValues = "适用ID")
    private String busiId;
    @ApiModelProperty(required = false, value = "备注", allowableValues = "备注")
    private String commment;

    public Integer getUseScope() {
        return useScope;
    }

    public CandyCouponRuleBuildParam setUseScope(Integer useScope) {
        this.useScope = useScope;
        return this;
    }

    public String getBusiName() {
        return busiName;
    }

    public CandyCouponRuleBuildParam setBusiName(String busiName) {
        this.busiName = busiName;
        return this;
    }

    public String getBusiId() {
        return busiId;
    }

    public CandyCouponRuleBuildParam setBusiId(String busiId) {
        this.busiId = busiId;
        return this;
    }

    public String getCommment() {
        return commment;
    }

    public CandyCouponRuleBuildParam setCommment(String commment) {
        this.commment = commment;
        return this;
    }

    private static final CandyCouponRuleBuildParam obj = new CandyCouponRuleBuildParam();

    public static CandyCouponRuleBuildParam getNew() {
        try {
            return (CandyCouponRuleBuildParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCouponRuleBuildParam();
        }
    }
}
