package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinBuyNoticeServiceImpl;
import com.liquidnet.service.kylin.dto.param.BuyNoticeParam;
import com.liquidnet.service.kylin.dto.param.BuyNoticeSearchParam;
import com.liquidnet.service.kylin.dto.vo.BuyNoticeVo;
import com.liquidnet.service.kylin.entity.KylinBuyNotice;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 须知管理 后端管理控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2026-01-16
 */
@Controller
@RequestMapping("/kylin/notices")
public class KylinNoticesAdminController extends BaseController {

    private String prefix = "zhengzai/kylin/notices";

    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;

    @Autowired
    private KylinBuyNoticeServiceImpl kylinNoticesServiceImpl;

    @GetMapping("/create")
    public String create(ModelMap mmap) {
        mmap.put("platformUrl", platformUrl);
        return prefix + "/create";
    }

    @Log(title = "创建须知", businessType = BusinessType.INSERT)
    @RequiresPermissions("kylin:notices:create")
    @PostMapping("create")
    @ResponseBody
    public AjaxResult createSave(BuyNoticeParam param) {
        Boolean res = kylinNoticesServiceImpl.create(param);
        if (res) {
            return success();
        } else {
            return error("添加须知失败");
        }
    }

    @GetMapping("/update/{buyNoticeId}")
    public String update(@PathVariable("buyNoticeId") String buyNoticeId, ModelMap mmap) {
        BuyNoticeVo result = kylinNoticesServiceImpl.detail(buyNoticeId);
        mmap.put("BuyNoticeVo", result);
        mmap.put("platformUrl", platformUrl);
        return prefix + "/update";
    }

    @Log(title = "修改须知", businessType = BusinessType.UPDATE)
    @RequiresPermissions("kylin:notices:update")
    @PostMapping("update")
    @ResponseBody
    public AjaxResult updateSave(BuyNoticeParam param) {
        Boolean res = kylinNoticesServiceImpl.update(param);
        if (res) {
            return success();
        } else {
            return error("修改须知失败");
        }
    }

    @RequiresPermissions("kylin:notices:detail")
    @GetMapping("/detail/{buyNoticeId}")
    public String detail(@PathVariable("buyNoticeId") String buyNoticeId, ModelMap mmap) {
        BuyNoticeVo result = kylinNoticesServiceImpl.detail(buyNoticeId);
        mmap.put("BuyNoticeVo", result);
        return prefix + "/detail";
    }

    @RequiresPermissions("kylin:notices:list")
    @GetMapping()
    public String notices() {
        return prefix + "/notices";
    }

//    @Log(title = "须知列表", businessType = BusinessType.LIST)
    @RequiresPermissions("kylin:notices:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo noticeList(BuyNoticeSearchParam param) {
        PageInfo<BuyNoticeVo> result = kylinNoticesServiceImpl.noticeListVo(param);
        return getDataTable(result.getList());
    }

    @Log(title = "删除须知", businessType = BusinessType.DELETE)
    @RequiresPermissions("kylin:notices:delete")
    @PostMapping("delete")
    @ResponseBody
    public AjaxResult delete(BuyNoticeParam param) {
        List<String> buyNoticeIds = param.getIds();
        Boolean result = kylinNoticesServiceImpl.delete(buyNoticeIds);
        if (result) {
            return success("删除成功");
        } else {
            return error("删除失败");
        }
    }
}
