package com.liquidnet.service.smile.entity.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SmilePriceIdPhoneDao implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 演出id
     */
    private String performancesId;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 打款金额
     */
    private BigDecimal price;

    /**
     * 打款记录保留
     */
    private String record;

    /**
     * 打款标识0：未打款，1：已打款
     */
    private Integer status;

    /**
     * 0：未删除，1：已删除
     */
    private Integer delTag;

    /**
     * 证件号
     */
    private String idCard;

    /**
     * 手机
     */
    private String phone;

    /**
     * 总代名称
     */
    private String name;

    /**
     * 创建时间
     */
    private LocalDateTime createdDate;

    /**
     * 修改时间
     */
    private LocalDateTime updatedDate;

    private static final SmilePriceIdPhoneDao obj = new SmilePriceIdPhoneDao();

    public static SmilePriceIdPhoneDao getNew() {
        try {
            return (SmilePriceIdPhoneDao) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmilePriceIdPhoneDao();
        }
    }

}
