package com.liquidnet.service.goblin.service.impl.inner;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.MdbMessage;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class GoblinQueBizArtworkMdbService {
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    MongoTemplate mongoTemplate;

    /**
     * 查取`Redis`数据至`Mongo`
     *
     * @param msg `JsonUtils.toJson(MdbMessage)`
     * @return ResponseDto<String>
     */
    public ResponseDto<String> bizMongoAdaptProcessing(String msg) {
        try {
            MdbMessage queueBizMongoDto = JsonUtils.fromJson(msg, MdbMessage.class);
            if (null != queueBizMongoDto) {
                String collectName = queueBizMongoDto.getCollect(), columnName = queueBizMongoDto.getColumn();
                String prefix = queueBizMongoDto.getPrefix(), bizId = queueBizMongoDto.getBizId();

                Object o;
                switch (queueBizMongoDto.getOpType()) {
                    case 1:// insert
                        o = goblinRedisUtils.get(prefix.concat(bizId));
                        if (null != o) {
                            mongoTemplate.insert(o, collectName);
                        } else {
                            log.warn("#MDB数据处理:处理失败[Redis获取数据为空,msg={}]", msg);
//                            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.BIZ_NFT_MONGO.getKey(), msg);
//                            return ResponseDto.failure("处理失败");
                        }
                        break;
                    case 2:// update
                        o = goblinRedisUtils.get(prefix.concat(bizId));
                        if (null != o) {
                            BasicDBObject basicDBObject = ObjectUtil.cloneBasicDBObject();
                            UpdateResult updateResult = mongoTemplate.getCollection(collectName).updateOne(
                                    Query.query(Criteria.where(columnName).is(bizId)).getQueryObject(),
                                    basicDBObject.append("$set", mongoTemplate.getConverter().convertToMongoType(o))
                            );
                        } else {
                            log.warn("#MDB数据处理:处理失败[Redis获取数据为空,msg={}]", msg);
//                            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.BIZ_NFT_MONGO.getKey(), msg);
//                            return ResponseDto.failure("处理失败");
                        }
                        break;
                    default:
                        log.warn("#MDB数据处理:无效操作[未知的操作类型,msg={}]", msg);
                        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.BIZ_NFT_MONGO.getKey(), msg);
                        return ResponseDto.failure("无效操作");
                }
            }
        } catch (Exception e) {
            log.error("Ex.MDB数据处理:处理异常[msg={}]", msg, e);
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.BIZ_NFT_MONGO.getKey(), msg);
            return ResponseDto.failure("操作异常");
        }
        return ResponseDto.success();
    }

    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */



    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
}
