package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商城订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreOrderVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = " 订单id")
    private String orderId;
    @ApiModelProperty(value = " 店铺id")
    private String storeId;
    @ApiModelProperty(value = " 店铺Name")
    private String storeName;
    @ApiModelProperty(value = " 主订单code  下单可能会同时下多个订单 ")
    private String masterOrderCode;
    @ApiModelProperty(value = " 订单号")
    private String orderCode;
    @ApiModelProperty(value = " 支付单号")
    private String payCode;
    @ApiModelProperty(value = " 用户id")
    private String userId;
    @ApiModelProperty(value = " 用户昵称")
    private String userName;
    @ApiModelProperty(value = " 用户手机号")
    private String userMobile;
    @ApiModelProperty(value = " 应付金额")
    private BigDecimal priceTotal;
    @ApiModelProperty(value = " 实付金额")
    private BigDecimal priceActual;
    @ApiModelProperty(value = " 退款价格")
    private BigDecimal priceRefund;
    @ApiModelProperty(value = " 商铺营销表id")
    private BigDecimal priceExpress;
    @ApiModelProperty(value = " 管理员修改优惠金额")
    private BigDecimal priceModify;
    @ApiModelProperty(value = "券优惠金额")
    private BigDecimal priceCoupon;
    @ApiModelProperty(value = " 总优惠价格")
    private BigDecimal priceVoucher;
    @ApiModelProperty(value = " 订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)]")
    private Integer status;
    @ApiModelProperty(value = " 券id")
    private String ucouponId;
    @ApiModelProperty(value = " 支付类型[wepay-微信支付|alipay-阿里支付|douyinpay-抖音支付|unionpay-银联支付]")
    private String payType;
    @ApiModelProperty(value = " 支付来源")
    private String deviceFrom;
    @ApiModelProperty(value = " 取消原因")
    private String cancelReason;
    @ApiModelProperty(value = " 订单来源[app|h5|applet]")
    private String source;
    @ApiModelProperty(value = " 版本号")
    private String version;
    @ApiModelProperty(value = " 是否会员")
    private Integer isMember;
    @ApiModelProperty(value = "订单类型[0-普通订单|1-定金预售订单|2-全款预售订单|3-拼团订单|4-众筹全款|5-众筹1元|6-众筹无回报|7-虚拟商品订单|8-社区团购订单|9-正在下单]")
    private Integer orderType;
    @ApiModelProperty(value = " 支付时间")
    private String payTime;
    @ApiModelProperty(value = " 取消时间")
    private String cancelTime;
    @ApiModelProperty(value = " 管理员修改订单时间")
    private String modifyTime;
    @ApiModelProperty(value = " 抽奖状态[0-未抽奖|1-中奖|2-已抽奖]")
    private String lotteryStatus;
    @ApiModelProperty(value = " 虚拟订单核销码[正在支付取货码]")
    private String writeOffCode;
    @ApiModelProperty(value = " 订单过期时间(分钟)")
    private Integer payCountdownMinute;
    @ApiModelProperty(value = " 快递单号")
    private String mailNo;
    @ApiModelProperty(value = " 发货时间")
    private String deliveryTime;
    @ApiModelProperty(value = " 物流公司姓名")
    private String logisticsCompany;
    @ApiModelProperty(value = " 物流公司code[物流公司id]")
    private String logisticsCode;
    @ApiModelProperty(value = " ip")
    private String ipAddress;
    @ApiModelProperty(value = " paymentId")
    private String paymentId;
    @ApiModelProperty(value = " paymentType")
    private String paymentType;
    @ApiModelProperty(value = " 创建时间")
    private String createdAt;

    @ApiModelProperty(value = "orderAttr")
    private GoblinOrderAttrVo orderAttrVo;
    @ApiModelProperty(value = "orderSkuId")
    private List<String> orderSkuVoIds;

    public BigDecimal getPriceModify() {
        if (priceModify == null) {
            return BigDecimal.ZERO;
        }
        return priceModify;
    }

    public BigDecimal getPriceVoucher() {
        if (priceVoucher == null) {
            return BigDecimal.ZERO;
        }
        return priceVoucher;
    }

    private static final GoblinStoreOrderVo obj = new GoblinStoreOrderVo();

    public static GoblinStoreOrderVo getNew() {
        try {
            return (GoblinStoreOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreOrderVo();
        }
    }
}
