package com.liquidnet.service.platform.controller.goblin.code;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.param.GoblinNftExCodeParam;
import com.liquidnet.service.goblin.service.IGoblinNftExCodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/19 2:53 下午
 */

@Api(tags = "兑换码")
@Slf4j
@Validated
@RestController
@RequestMapping("code")
public class GoblinNftExCodeController {

    @Autowired
    IGoblinNftExCodeService iGoblinNftExCodeService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "根据nft兑换活动获取兑换码")
    @PostMapping("selectCodePageList")
    public ResponseDto<Object> selectCodePageList(@RequestBody GoblinNftExCodeParam goblinNftExCodeParam){
        return ResponseDto.success(iGoblinNftExCodeService.selectCodePageList(goblinNftExCodeParam));
    }





}
