package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetArtists;
import com.liquidnet.service.sweet.entity.SweetManualShop;
import com.liquidnet.service.sweet.mapper.SweetManualShopMapper;
import com.liquidnet.service.sweet.service.ISweetManualShopService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 电子宣传手册商铺表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-29
 */
@Service
public class SweetManualShopServiceImpl extends ServiceImpl<SweetManualShopMapper, SweetManualShop> implements ISweetManualShopService {

    @Autowired
    private SweetManualShopMapper sweetManualShopMapper;

    @Override
    public ResponseDto<List<SweetManualShop>> getList(String manualId) {
        try {
            List<SweetManualShop> data = sweetManualShopMapper.selectList(Wrappers.lambdaQuery(SweetManualShop.class).eq(SweetManualShop::getManualId, manualId).eq(SweetManualShop::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShop sweetManualShop = SweetManualShop.getNew();
            sweetManualShop.setManualShopId(IDGenerator.nextSnowId());
            sweetManualShop.setManualId(manualId);
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribe(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShop.setStatus(1);
            sweetManualShopMapper.insert(sweetManualShop);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualShopId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShop sweetManualShop = SweetManualShop.getNew();
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribe(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShopMapper.update(sweetManualShop,Wrappers.lambdaUpdate(SweetManualShop.class).eq(SweetManualShop::getManualShopId, manualShopId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualShopId) {
        try {
            SweetManualShop sweetManualShop = SweetManualShop.getNew();
            sweetManualShop.setStatus(0);
            sweetManualShopMapper.update(sweetManualShop,Wrappers.lambdaUpdate(SweetManualShop.class).eq(SweetManualShop::getManualShopId, manualShopId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }
}
