package com.liquidnet.service.kylin.dto.vo.returns;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketRelations;
import com.liquidnet.service.kylin.entity.KylinOrderTicketStatus;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "KylinOrderTicketVo", description = "订单数据")
@Data
public class KylinOrderTicketPreVo implements Serializable {
    private Integer mid;
    private static final long serialVersionUID = 5325511589667456213L;
    @ApiModelProperty(position = 10, value = "ID")
    private String orderTicketsId;
    @ApiModelProperty(position = 11, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 12, value = "用户昵称")
    private String userName;
    @ApiModelProperty(position = 13, value = "用户手机号")
    private String userMobile;
    @ApiModelProperty(position = 14, value = "演出名称")
    private String performanceTitle;
    private String ticketTitle;
    private String timeStart;
    private String useStart;
    private String performanceImg;
    private Integer number;
    private BigDecimal priceTotal;
    private BigDecimal priceVoucher;
    private BigDecimal priceActual;
    private BigDecimal priceExpress;
    private BigDecimal priceRefund;
    private Integer refundNumber;
    private String couponType;
    private String getTicketType;

    private Integer expressType;
    private Integer status;
    private String performanceId;
    private String timeId;
    private String ticketId;
    private String fieldName;
    private Integer isTrueName;
    private List<KylinOrderTicketEntitiesPreRefundVo> entitiesPreRefundVos;
}
