package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "AdamUserProfileVo", description = "个人信息响应数据")
@Data
public class AdamUserProfileVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 3782062486028972984L;
    @ApiModelProperty(position = 11, value = "用户信息")
    private AdamUserInfoVo userInfo;
    @ApiModelProperty(position = 12, value = "实名信息")
    private AdamRealInfoVo realNameInfo;
    @ApiModelProperty(position = 13, value = "用户第三方账号信息")
    private List<AdamThirdPartInfoVo> thirdPartInfo;
    @ApiModelProperty(position = 14, value = "会员信息")
    private AdamMemberSimpleVo memberVo;
    @ApiModelProperty(position = 15, value = "用户会员信息")
    private AdamUserMemberVo userMemberVo;
    @ApiModelProperty(position = 16, value = "会员卡信息")
    private AdamMemberJoinusVo memberJoinusVo;
    @ApiModelProperty(position = 17, value = "业务账号信息")
    private List<AdamUserBizAcctVo> bizAcctVoList;

    private static final AdamUserProfileVo obj = new AdamUserProfileVo();

    public static AdamUserProfileVo getNew() {
        try {
            return (AdamUserProfileVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamUserProfileVo();
        }
    }
}
