package com.liquidnet.service.galaxy.constant;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyErrorCodeEnum
 * @Package com.liquidnet.service.galaxy.constant
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/8 11:25
 */
public enum GalaxyErrorEnum {
    SERIES_CLAIM_ERROR("NFT0010001","NFT系列声明失败"),
    SERIES_CLAIM_ERROR_FIVE_TIMES("NFT0010002","NFT系列声明失败,任务查询超过5次"),
    PUBLISH_FAIL("NFT0010003","NFT发行失败,未获取nft"),
    PUBLISH_BUY_FAIL("NFT0010004","NFT发行购买失败,未发起购买"),
    PUBLISH_FAIL_ALREADY_EXIST("NFT0010005","NFT发行失败,该订单已经发行过指定nft！"),
    ROUTER_NOT_EXIST("NFT0010006","路由类型不存在"),
    SERIES_NOT_EXIST("NFT0010007","没有查询到该sku对应系列声明"),
    SERIES_CLAIM_PROCESSING("NFT0010008","系列声明正在处理中,不允许重复声明！"),
    SERIES_CLAIM_SUCCESSED("NFT0010009","系列已声明成功，不允许重复声明！"),
    SERIES_CLAIM_NOT_EXIST("NFT0010010","系列声明初始化信息不存在，请检查是否已上传对应素材！"),
    SERIES_NFT_INFO_NOT_EXIST("NFT0010015","系列NFT信息查询不存在！"),
    PUBLISH_ORDER_NOT_EXIST("NFT0010011","NFT购买订单不存在!"),
    NFT_BUY_TASK_NOT_EXIST("NFT0010012","NFT购买执行任务不存在"),
    NFT_BUY_TASK_HAVE_EXIST("NFT0010013","NFT购买执行任务已存在，不可以重复购买!"),
    NFT_BUY_FAIL("NFT0010014","NFT购买失败，nftId不存在!"),
    NFT_BUY_FAIL_USER_NOT_EXIST("NFT0010015","NFT购买失败，用户信息不存在!"),
    NFT_BUY_FAIL_SERIES_NFT_NOT_EXIST("NFT0010016","NFT购买失败，系列NFT信息不存在!"),
    NFT_PUBLISH_ERROR("NFT0010017","NFT发行异常!"),
    NFT_BUY_ERROR("NFT0010018","NFT购买异常!"),
    NFT_PUBLISH_AND_BUY_QUERY_FAIL("NFT0010019","NFT发行和购买结果查询失败!");


    private String code;
    private String message;
    GalaxyErrorEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }
    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
