package com.liquidnet.service.platform.controller.kylin;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.impl.kylin.DataImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "数据迁移 (会重复)")
@RestController
@RequestMapping("data")
public class DataController {

    @Autowired
    private DataImpl data;


    @PostMapping("fieldData")
    @ApiOperation("场地数据迁移")
    public ResponseDto<Boolean> fieldData() {
        data.fieldData();
        return ResponseDto.success();
    }

    @PostMapping("account")
    @ApiOperation("演出关联用户id迁移")
    public ResponseDto<Boolean> account() {
        data.account();
        return ResponseDto.success();
    }

    @PostMapping("sponsor")
    @ApiOperation("主办方相关迁移")
    public ResponseDto<Boolean> sponsor() {
        data.sponsor();
        return ResponseDto.success();
    }

    @PostMapping("checkTicket")
    @ApiOperation("验票账号相关迁移")
    public ResponseDto<Boolean> checkTicket() {
        data.checkTicket();
        return ResponseDto.success();
    }

//    @PostMapping("initScore")
//    @ApiOperation("积分数据迁移")
//    public ResponseDto<Boolean> initScore(@RequestParam("page") int page, @RequestParam("size") int size) {
//        Boolean result = data.initScore(page,size);
//        return ResponseDto.success(result);
//    }
//
//    @PostMapping("initScoreSingle")
//    @ApiOperation("积分数据迁移(根据uid)")
//    public ResponseDto<Boolean> initScore(@RequestParam("uid") String uid) {
//        Boolean result = data.initScore(uid);
//        return ResponseDto.success(result);
//    }
//
//    @PostMapping("initLogsSingle")
//    @ApiOperation("初始化用户积分日志(根据uid)")
//    public ResponseDto<Boolean> initLogs(@RequestParam("uid") String uid) {
//        Boolean result = data.initLogs(uid);
//        return ResponseDto.success(result);
//    }

}
