package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtCouponActionParam", description = "商铺活动:优惠券操作入参")
@Data
public class GoblinStoreMgtCouponActionParam implements Serializable {
    private static final long serialVersionUID = 1510610282408466586L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "操作类型[ENABLED-启用|DISABLED-停用|REMOVE-删除]")
    @Pattern(regexp = "\\b(ENABLED|DISABLED|REMOVE)\\b", message = "操作类型无效")
    private String action;
    @ApiModelProperty(position = 12, required = true, value = "优惠券ID列表")
    private List<String> storeCouponIdList;
}
