package com.liquidnet.service.merchant.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.merchant.entity.MerchantAuthorizationPermissions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "MerchantAuthorizationPermissionsVo", description = "授权记录关联")
@Data
public class MerchantAuthorizationPermissionsVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -771282476240311975L;

    @ApiModelProperty(value = "authorization_permission_id")
    private String authorizationPermissionId;

    @ApiModelProperty(value = "authorization_record_id")
    private String authorizationRecordId;

    @ApiModelProperty(value = "permission_id")
    private String permissionId;

    @ApiModelProperty(value = "授权开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime startTime;
    @ApiModelProperty(value = "授权结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime endTime;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final MerchantAuthorizationPermissionsVo obj = new MerchantAuthorizationPermissionsVo();

    public static MerchantAuthorizationPermissionsVo getNew() {
        try {
            return (MerchantAuthorizationPermissionsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MerchantAuthorizationPermissionsVo();
    }

    public MerchantAuthorizationPermissionsVo copy(MerchantAuthorizationPermissions source) {
        if (null == source) return this;

        this.setAuthorizationPermissionId(source.getAuthorizationPermissionId());
        this.setAuthorizationRecordId(source.getAuthorizationRecordId());
        this.setPermissionId(source.getPermissionId());

        this.setStartTime(source.getStartTime());
        this.setEndTime(source.getEndTime());

        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());

        return this;
    }
}
