package com.liquidnet.service.goblin.param;

import com.liquidnet.service.goblin.dto.vo.GoblinUserCouponVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Api
@Data
public class CouponHelpUseVo implements Serializable, Cloneable {
//    @ApiModelProperty(name = "param", value = "对象")
//    private List<CouponCanUse2Param> param;
//    @ApiModelProperty(name = "couponVo", value = "券vo")
//    private GoblinUserCouponVo couponVo;
    @ApiModelProperty(dataType = "String", name = "ucouponId", value = "券id", required = true)
    private String ucouponId;
    @ApiModelProperty(dataType = "String", name = "platformUcouponId", value = "平台券id", required = true)
    private String platformUcouponId;
    @ApiModelProperty(dataType = "number", name = "price", value = "优惠金额", required = true)
    private BigDecimal price;

    private static final CouponHelpUseVo obj = new CouponHelpUseVo();

    public static CouponHelpUseVo getNew() {
        try {
            return (CouponHelpUseVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CouponHelpUseVo();
    }

}
