package com.liquidnet.client.admin.zhengzai.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetAdminActiveTypeService;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetAdminQrCodeService;
import com.liquidnet.client.admin.zhengzai.sweet.utils.SweetRedisAdminUtils;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dto.param.CreateActiveQrCodeParam;
import com.liquidnet.service.kylin.dto.param.CreateActiveTypeParam;
import com.liquidnet.service.sweet.entity.SweetActiveType;
import com.liquidnet.service.sweet.entity.SweetQrCode;
import com.liquidnet.service.sweet.mapper.SweetActiveTypeMapper;
import com.liquidnet.service.sweet.mapper.SweetQrCodeMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
@Slf4j
public class SweetAdminQrCodeServiceImpl implements ISweetAdminQrCodeService {

    @Autowired
    SweetQrCodeMapper sweetQrCodeMapper;
    @Autowired
    SweetRedisAdminUtils sweetRedisAdminUtils;

    @Override
    public List<SweetQrCode> getList(String type) {
        List<SweetQrCode> list = sweetQrCodeMapper.selectList(Wrappers.lambdaQuery(SweetQrCode.class).eq(SweetQrCode::getType, type));
        for (SweetQrCode item : list) {
            item.setShowNum(sweetRedisAdminUtils.getQrCodeShowNum(Integer.parseInt(type), item.getQrCodeId()));
        }
        return list;
    }

    @Override
    public Boolean addQrCode(CreateActiveQrCodeParam createActiveTypeParam) {
        try {
            SweetQrCode bean = SweetQrCode.getNew();
//            int count = sweetQrCodeMapper.selectCount(Wrappers.lambdaQuery(SweetQrCode.class).eq(SweetQrCode::getType, createActiveTypeParam.getType()));
//            for (int i = 0; i < createActiveTypeParam.getCount(); i++) {
//                int swat = count + i + 1;
            String qrCodeId = IDGenerator.nextMilliId();
            bean.setQrCodeId(qrCodeId);
            bean.setUrl(createActiveTypeParam.getUrl());
            bean.setReadNum(0);
            bean.setShowNum(0);
            bean.setType(createActiveTypeParam.getType());
            sweetQrCodeMapper.insert(bean);
            //初始化 展示次数 读取次数
            sweetRedisAdminUtils.initQrCodeShowNum(createActiveTypeParam.getType(), qrCodeId);
            sweetRedisAdminUtils.initQrCodeReadNum(createActiveTypeParam.getType(), qrCodeId);
//            }
            //纪录实体类List
            sweetRedisAdminUtils.setQrCodeDetails(createActiveTypeParam.getType(), sweetQrCodeMapper.selectList(Wrappers.lambdaQuery(SweetQrCode.class).eq(SweetQrCode::getType, createActiveTypeParam.getType())));
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public SweetQrCode details(String mid) {
        return sweetQrCodeMapper.selectOne(Wrappers.lambdaQuery(SweetQrCode.class).eq(SweetQrCode::getMid, mid));
    }

    @Override
    public Boolean changeInfo(CreateActiveQrCodeParam createActiveTypeParam) {
        SweetQrCode bean = SweetQrCode.getNew();
        bean.setReadNum(createActiveTypeParam.getReadNum());
        sweetRedisAdminUtils.setQrCodeReadNum(createActiveTypeParam.getType(), createActiveTypeParam.getQrCodeId(), createActiveTypeParam.getReadNum());
        return sweetQrCodeMapper.update(bean, Wrappers.lambdaUpdate(SweetQrCode.class).eq(SweetQrCode::getMid, createActiveTypeParam.getMid())) > 0;
    }
}
