package com.liquidnet.common.third.shumei.biz;

import com.alibaba.fastjson.JSONObject;
import com.liquidnet.common.third.shumei.config.ShumeiConfig;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ShumeiBiz
 * @Package com.liquidnet.common.third.shumei.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/7 18:49
 */
@Component
public class ShumeiBiz{
    @Autowired
    private ShumeiConfig shumeiConfig;

    /**
     *
     * @param text
     * @param userId
     * @return
     */
    public JSONObject checkText(String userId,String text){
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("accessKey", shumeiConfig.getAccessKey());
        payload.put("appId", "default");
        payload.put("eventId", "nickname");
        payload.put("type", "ALL");

        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("text", text);
        data.put("tokenId", userId);

        payload.put("data", data);

        JSONObject json = JSONObject.parseObject(JsonUtils.toJson(payload));
        JSONObject result = HttpUtil.httpPost(shumeiConfig.getTextUrl(), json);
        return result;
    }


    public JSONObject checkImage(String userId,String imageUrl){
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("accessKey", shumeiConfig.getAccessKey());
        payload.put("appId", "default");
        payload.put("eventId", "article");
        payload.put("type", "POLITICS_PORN_AD_BAN_VIOLENCE");

        //请求的数据内容，最长10MB
        HashMap<String, Object> data = new HashMap<String, Object>();
//        data.put("img", Utils.readFileToBase64("../files/demo.png"));
        data.put("img", imageUrl);
        data.put("tokenId", userId);

        payload.put("data", data);

        JSONObject json = JSONObject.parseObject(JsonUtils.toJson(payload));
        JSONObject result = HttpUtil.httpPost(shumeiConfig.getImageUrl(), json);
        return result;
    }
}
