package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinRechargeWristbandVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = " 手环ID")
    private String wristbandId;

    @ApiModelProperty(value = "手环名称")
    private String name;

    @ApiModelProperty(value = "手环价格")
    private BigDecimal price;

    @ApiModelProperty(value = "充值金额")
    private List<GoblinRechargeAmountVo> amonutList;

    private final static GoblinRechargeWristbandVo obj = new GoblinRechargeWristbandVo();

    public static GoblinRechargeWristbandVo getNew() {
        try {
            return (GoblinRechargeWristbandVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinRechargeWristbandVo();
        }
    }

}
