package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberOrderPreviewVo", description = "会员订单预览")
@Data
public class AdamMemberOrderPreviewVo implements Serializable {
    private static final long serialVersionUID = 2035177741044060344L;
    @ApiModelProperty(position = 10, value = "会员ID[50]")
    private String memberId;
    @ApiModelProperty(position = 11, value = "会员标题[50]")
    private String memberTitle;
    @ApiModelProperty(position = 12, value = "价格详情")
    private AdamMemberPriceVo priceVo;
    @ApiModelProperty(position = 13, value = "实名信息")
    private AdamRealInfoVo realInfoVo;
    @ApiModelProperty(position = 14, value = "生日")
    private String birthday;
    @ApiModelProperty(position = 15, value = "常住地/区域 ～ 已废除，参见[province、city、county]")
    private String area;
    @ApiModelProperty(position = 20, value = "标记[0-普通用户｜2-过期会员｜10-老会员｜11-新会员]")
    private Integer stageMarker;

    @ApiModelProperty(position = 21, value = "常住地/省 ～ 替换原字段[area]")
    private String province;
    @ApiModelProperty(position = 22, value = "常住地/市 ～ 替换原字段[area]")
    private String city;
    @ApiModelProperty(position = 23, value = "常住地/区县 ～ 替换原字段[area]")
    private String county;

    private static final AdamMemberOrderPreviewVo obj = new AdamMemberOrderPreviewVo();

    public static AdamMemberOrderPreviewVo getNew() {
        try {
            return (AdamMemberOrderPreviewVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderPreviewVo();
        }
    }
}
