package com.liquidnet.service.executor.main.handler;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DESUtils;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.service.feign.kylin.task.FeignPlatformAlipayBackClient;
import com.liquidnet.service.feign.platform.api.FeignPlatformApiClient;
import com.liquidnet.service.feign.platform.kylin.FeignPlatformFreightClient;
import com.liquidnet.service.feign.platform.task.FeignPlatformCandyTaskClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;

/**
 * Platform
 */
@Component
public class PlatformTaskHandler {
    @Value("${liquidnet.service.platform.url}")
    private String sevPlatformUrl;

    @Autowired
    private FeignPlatformAlipayBackClient feignPlatformAlipayBackClient;
    @Autowired
    private FeignPlatformCandyTaskClient feignPlatformCandyTaskClient;
    @Autowired
    private FeignPlatformFreightClient feignPlatformFreightClient;

    @Autowired
    FeignPlatformApiClient feignPlatformApiClient;

    @XxlJob(value = "sev-platform:describeDevices")
    public void describeDevices() {
        try {
            String jobParam = XxlJobHelper.getJobParam();
            String[] paramArray = jobParam.split(",");
            XxlJobHelper.handleSuccess("结果：" + feignPlatformApiClient.describeDevices(Integer.parseInt(paramArray[0]), Integer.parseInt(paramArray[1])).getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:detectPedestrian")
    public void detectPedestrian() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformApiClient.detectPedestrian().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:overtimeRefund")
    public void overtimeRefund() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformApiClient.overtimeRefund().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:alipayActiveCallbackHandler")
    public void alipayActiveCallbackHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformAlipayBackClient.alipayActiveCallback().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:candyCouponMgtIssueCoupons")
    public void candyCouponMgtIssueCoupons() {// 券中心：发放券
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformCandyTaskClient.mgtIssueCoupons().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:candyCouponDueProcessForRedeem")
    public void candyCouponDueProcessForRedeem() {// 券中心：码到期处理
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformCandyTaskClient.dueProcessForRedeem().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:candyCouponDueProcessForCommon")
    public void candyCouponDueProcessForCommon() {// 券中心：券到期处理（公有券）
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformCandyTaskClient.dueProcessForCommon().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:candyCouponDueProcessForUser")
    public void candyCouponDueProcessForUser() {// 券中心：券到期处理（私有券）
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformCandyTaskClient.dueProcessForUser().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:candyUserCouponRmvProcessing")
    public void candyUserCouponRmvProcessing() {// 券中心：券移除处理
        try {
            String url = sevPlatformUrl.concat("/platform/ccoupon/task/due/rmv");
            LinkedMultiValueMap<String, String> paramsMap = CollectionUtil.linkedMultiValueMapStringString();
            String jobParam = XxlJobHelper.getJobParam();
            paramsMap.add("displayDays", DESUtils.DES().encrypt(StringUtils.isNotBlank(jobParam) ? jobParam : "31"));
            LinkedMultiValueMap<String, String> headersMap = CollectionUtil.linkedMultiValueMapStringString();
            headersMap.add("Accept", MediaType.APPLICATION_JSON_UTF8_VALUE);
            headersMap.add("Content-Type", MediaType.APPLICATION_FORM_URLENCODED_VALUE);

            XxlJobHelper.handleSuccess("结果：" + HttpUtil.post(url, paramsMap, headersMap));
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:getFreightChargeHandler")
    public void getFreightChargeHandler() {//运费
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformFreightClient.getFreightCharge().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:followDoTask")
    public void followDoTask() {// 关注任务加积分脚本
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformCandyTaskClient.doTask().toJson());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
}
