package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.service.goblin.dto.vo.GoblinSelfGoodsCategoryVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo;
import com.liquidnet.service.goblin.dto.vo.GoblinServiceSupportVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtExtraService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class GoblinStoreMgtExtraServiceImpl implements IGoblinStoreMgtExtraService {
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public List<GoblinSelfGoodsCategoryVo> listCategoryVo() {
        return goblinRedisUtils.getSelfGoodsCategoryVos();
    }

    @Override
    public List<GoblinSelfTagVo> listTagVo(String keyword, String belong) {
        return goblinMongoUtils.getSelfTagVos(belong, keyword);
    }

    @Override
    public List<GoblinServiceSupportVo> listServiceSupportVo() {
        List<GoblinServiceSupportVo> serviceSupportVos = goblinRedisUtils.getServiceSupportVos();
        if (CollectionUtils.isEmpty(serviceSupportVos)) {
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("正品保证").setDesc("商品为正版行货").setSsid("101"));
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("极速发货").setDesc("24小时内发送货物").setSsid("102"));
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("无忧退货").setDesc("支持7天无理由退款").setSsid("103"));

            List<GoblinServiceSupportVo> serviceSupportVoList = goblinMongoUtils.insertMgtServiceSupportVos(serviceSupportVos);
            // TODO: 2022/1/4 zhanggb + queue.sql
        }
        return serviceSupportVos;
    }
}
