package com.liquidnet.service.dragon.service.impl;

import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.channel.strategy.PayChannelStrategyContext;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.constant.DragonErrorCodeEnum;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.dto.DragonPayOrderQueryRespDto;
import com.liquidnet.service.dragon.service.IDragonOrdersService;
import com.liquidnet.service.dragon.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@Service
public class DragonOrdersServiceImpl implements IDragonOrdersService {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private PayChannelStrategyContext payChannelStrategyContext;

    @Autowired
    private DataUtils dataUtils;

    @Override
    public ResponseDto<DragonPayBaseRespDto> dragonPay(DragonPayBaseReqDto dragonPayBaseReqDto) {
        //设置支付编号
        dragonPayBaseReqDto.setCode(IDGenerator.payCode());
        return payChannelStrategyContext.getStrategy(dragonPayBaseReqDto.getPayType()).dragonPay(dragonPayBaseReqDto);
    }

    @Override
    public void dragonNotify(HttpServletRequest request,String payType,String deviceFrom) {
        payChannelStrategyContext.getStrategy(payType).dragonNotify(request,payType,deviceFrom);
    }

    @Override
    public DragonPayOrderQueryRespDto checkOrderStatusByCode(String code) {
        DragonOrdersDto ordersDto = dataUtils.getPayOrderByCode(code);
        if(StringUtil.isEmpty(ordersDto)){
            throw new LiquidnetServiceException(DragonErrorCodeEnum.TRADE_ERROR_NOT_EXISTS.getCode(),DragonErrorCodeEnum.TRADE_ERROR_NOT_EXISTS.getMessage());
        }
        return payChannelStrategyContext.getStrategy(DragonConstant.PayTypeEnum.getEnumByCode(ordersDto.getPaymentType()).getPayType()).checkOrderStatus(code);
    }

    @Override
    public DragonPayOrderQueryRespDto checkOrderStatusByOrderCode(String orderCode) {
        return null;
    }
}
