package com.liquidnet.service.dragon.utils;

import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.dragon.bo.PayNotifyReqBo;
import com.liquidnet.service.dragon.constant.DragonConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.LinkedList;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: MqHandleUtil
 * @Package com.liquidnet.service.dragon.utils
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 16:23
 */
@Component
public class MqHandleUtil {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    /**
     * REDIS 队列发送消息 通知商户相关
     * @param payNotifyReqBo
     * @return
     */
    public boolean sendQueueAlipay(PayNotifyReqBo payNotifyReqBo) {
        try {
            HashMap<String, String> map = new HashMap<>();
            map.put("message", payNotifyReqBo.toString());
            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey(DragonConstant.ChannelRedisQueueEnum.ALIPAY_PAY_KEY.getCode());
            stringRedisTemplate.opsForStream().add(record);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * REDIS 队列发送消息 通知商户相关
     * @param payNotifyReqBo
     * @return
     */
    public boolean sendQueueWepay(PayNotifyReqBo payNotifyReqBo) {
        try {
            HashMap<String, String> map = new HashMap<>();
            map.put("message", payNotifyReqBo.toString());
            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey(DragonConstant.ChannelRedisQueueEnum.WECHAT_PAY_KEY.getCode());
            stringRedisTemplate.opsForStream().add(record);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 给 REDIS 队列发送消息 数据库相关
     *
     * @param sql  sql语句
     * @param data 需要操作的数据
     * @return
     */
    public boolean sendMySqlRedis(String sql, Object[] data) {
        try {
            LinkedList<String> sqls = new LinkedList<>();
            sqls.add(sql);
            LinkedList<Object[]> sqlsData = new LinkedList();
            sqlsData.add(data);
            String sqlData = SqlMapping.gets(sqls, sqlsData);

            HashMap<String, String> map = new HashMap<>();
            map.put("message", sqlData);
            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode());
            stringRedisTemplate.opsForStream().add(record);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
