package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftOrderBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/17 11:16
 */
@Data
public class GalaxyNftOrderBo implements Serializable,Cloneable {
    private String userId;
    /**
     * 应用系统购买系列唯一ID
     */
    private String skuId;
    /**
     * 系列的唯一名称
     */
    private String seriesName;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * 接入方买入唯一标识
     */
    private String nftOrderPayId;
    /**
     * nftId
     */
    private String nftId;
    /**
     * nft价格
     */
    private Long nftPrice;

    /**
     * 转出方地址
     */
    private String fromAddress;

    /**
     * 转入方地址
     */
    private String toAddress;

    /**
     * nft发行任务ID
     */
    private String nftPublishTaskId;

    /**
     * nft购买
     * @return
     */

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftOrderBo obj = new GalaxyNftOrderBo();

    public static GalaxyNftOrderBo getNew() {
        try {
            return (GalaxyNftOrderBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftOrderBo();
        }
    }
}
