package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberSimpleVo", description = "会员简述响应数据")
@Data
public class AdamMemberSimpleVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -3246848259206596250L;
    @ApiModelProperty(position = 10, value = "会员ID[50]")
    private String memberId;
    @ApiModelProperty(position = 11, value = "会员名称[50]", example = "摩登天空会员卡")
    private String name;
    @ApiModelProperty(position = 12, value = "会员标题[50]", example = "摩登天空会员卡")
    private String title;
    @ApiModelProperty(position = 13, value = "会员副标题[50]", example = "摩登天空会员卡副标题")
    private String subTitle;
    @ApiModelProperty(position = 14, value = "icon图标[200]", example = "https://img.zhengzai.tv/files/2020/08/28/5f490418d30b4.png")
    private String icon;

    private static final AdamMemberSimpleVo obj = new AdamMemberSimpleVo();

    public static AdamMemberSimpleVo getNew() {
        try {
            return (AdamMemberSimpleVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberSimpleVo();
        }
    }

    public AdamMemberSimpleVo copy(AdamMemberVo source) {
        if (null == source) return this;
        this.setMemberId(source.getMemberId());
        this.setName(source.getName());
        this.setTitle(source.getTitle());
        this.setSubTitle(source.getSubTitle());
        this.setIcon(source.getIcon());
        return this;
    }
}
