package com.liquidnet.client.admin.web.controller.zhengzai.merchant;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldAppliesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldsAdminService;
import com.liquidnet.service.merchant.dto.param.admin.MerchantFieldApplyListParam;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldAppliesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.entity.MerchantFieldApplies;
import com.liquidnet.service.merchant.entity.MerchantFields;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;


@Api(tags = "场地申请管理")
@Controller
@RequestMapping("merchant/field/apply")
public class MerchantFieldAppliesController extends BaseController {

    private final String prefix = "zhengzai/kylin/field";

    @Autowired
    IMerchantFieldsAdminService merchantFieldsAdminService;

    @Autowired
    IMerchantFieldAppliesAdminService merchantFieldAppliesAdminService;


    @RequiresPermissions("merchant:field:apply:view")
    @GetMapping()
    public String applyList() {
        return prefix + "/applyList";
    }


    @Log(title = "场地申请列表", businessType = BusinessType.LIST)
    @RequiresPermissions("merchant:field:apply:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(MerchantFieldApplyListParam param) {
        startPage();
        return getDataTable(merchantFieldAppliesAdminService.list(
                Wrappers.lambdaQuery(MerchantFieldApplies.class)
                        .eq(param.getFieldApplyId().length() > 0, MerchantFieldApplies::getFieldApplyId, param.getFieldApplyId())
                        .eq(param.getApplyStatus() >= 0, MerchantFieldApplies::getApplyStatus, param.getApplyStatus())
                        .eq(!param.getApplyType().equals("all"), MerchantFieldApplies::getApplyType, param.getApplyType())
                        .select(
                                MerchantFieldApplies::getFieldApplyId, MerchantFieldApplies::getApplyStatus, MerchantFieldApplies::getApplyType, MerchantFieldApplies::getReject, MerchantFieldApplies::getUid, MerchantFieldApplies::getFieldId,
                                MerchantFieldApplies::getName, MerchantFieldApplies::getLogo,
                                MerchantFieldApplies::getCreatedAt
                        )
        ));
    }

    @Log(title = "场地申请详情", businessType = BusinessType.DETAIL)
    @RequiresPermissions("merchant:field:apply:detail")
    @GetMapping("/details/{fieldApplyId}")
    public String detail(@PathVariable("fieldApplyId") String fieldApplyId, ModelMap mmap) {

        LambdaQueryWrapper<MerchantFieldApplies> fieldAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantFieldApplies.class);
        fieldAppliesLambdaQueryWrapper.eq(MerchantFieldApplies::getFieldApplyId, fieldApplyId);
        MerchantFieldApplies fieldApplies = merchantFieldAppliesAdminService.getOne(fieldAppliesLambdaQueryWrapper);

        MerchantFieldAppliesVo fieldAppliesVo = MerchantFieldAppliesVo.getNew();
        fieldAppliesVo.copy(fieldApplies);
        if (fieldAppliesVo.getApplyType().equals("claim")) {
            LambdaQueryWrapper<MerchantFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantFields.class);
            fieldsLambdaQueryWrapper.eq(MerchantFields::getFieldId, fieldAppliesVo.getFieldId());
            MerchantFields fields = merchantFieldsAdminService.getOne(fieldsLambdaQueryWrapper);

            MerchantFieldsVo fieldsVo = MerchantFieldsVo.getNew();
            fieldsVo.copy(fields);
            fieldAppliesVo.setFieldVo(fieldsVo);
        }

        mmap.put("fieldApplyInfo", fieldAppliesVo);

        return prefix + "/applyDetail";
    }

    @ApiOperation(value = "审核通过")
    @Log(title = "场地申请审核通过", businessType = BusinessType.INSERT)
    @RequiresPermissions("merchant:field:apply:approve")
    @PostMapping("/approve")
    @ResponseBody
    public AjaxResult approve(@RequestParam(required = true) String fieldApplyId) {
        String authUid = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();

        return toAjax(merchantFieldAppliesAdminService.applyApprove(fieldApplyId, authUid, authName));
    }

    @ApiOperation(value = "审核驳回")
    @Log(title = "场地申请审核驳回", businessType = BusinessType.INSERT)
    @RequiresPermissions("merchant:field:apply:reject")
    @PostMapping("/reject")
    @ResponseBody
    public AjaxResult reject(@RequestParam(required = true) String fieldApplyId,
                             @RequestParam(required = true) String reject) {
        String authUid = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();

        return toAjax(merchantFieldAppliesAdminService.applyReject(fieldApplyId, authUid, authName, reject));
    }
}
