package com.liquidnet.service.merchant.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "MerchantStationTicketVo", description = "票种统计信息")
@Data
public class MerchantStationTicketVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2995250476517713387L;
    @ApiModelProperty(position = 10, value = "票种ID[64]")
    private String ticketId;
    @ApiModelProperty(position = 11, value = "名称[32]")
    private String title;
    @ApiModelProperty(position = 12, value = "单价(8,2)")
    private BigDecimal price;
    @ApiModelProperty(position = 13, value = "适用开始时间")
    private String useStart;
    @ApiModelProperty(position = 14, value = "适用结束时间")
    private String useEnd;
    @ApiModelProperty(position = 15, value = "票房")
    private BigDecimal priceSum;
    @ApiModelProperty(position = 16, value = "票量[9]")
    private Integer number;
    @ApiModelProperty(position = 17, value = "已验票量[9]")
    private Integer checkedNum;
    @ApiModelProperty(position = 18, value = "余量[9]")
    private Integer remainderNum;

    private static final MerchantStationTicketVo obj = new MerchantStationTicketVo();

    public static MerchantStationTicketVo getNew() {
        try {
            return (MerchantStationTicketVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new MerchantStationTicketVo();
        }
    }
}
