package com.liquidnet.client.admin.zhengzai.smile.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 志愿者职责组搜索
 */
@Data
public class SmileVTSParam {

    @ApiModelProperty(value = "职责组名称", example = "")
    private String title;

    @ApiModelProperty(value = "页数", example = "1")
    @NotNull(message = "页数不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "数量不能为空")
    private Integer pageNum;

    @ApiModelProperty(value = "排序字段", hidden = true)
    private String orderItem;

    @ApiModelProperty(value = "排序方式", hidden = true)
    private String orderSc;
}
