package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualSortTfc;
import com.liquidnet.service.sweet.mapper.SweetManualSortTfcMapper;
import com.liquidnet.service.sweet.service.ISweetManualSortTFCService;
import com.liquidnet.service.sweet.utils.RedisTFCDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册显示内容表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualSortTFCServiceImpl extends ServiceImpl<SweetManualSortTfcMapper, SweetManualSortTfc> implements ISweetManualSortTFCService {

    @Autowired
    private SweetManualSortTfcMapper sweetManualSortTFCMapper;
    @Autowired
    private RedisTFCDataUtils redisDataUtils;

    @Override
    public ResponseDto<SweetManualSortTfc> get(String manualId) {
        try {
            return ResponseDto.success(sweetManualSortTFCMapper.selectOne(Wrappers.lambdaQuery(SweetManualSortTfc.class).eq(SweetManualSortTfc::getManualId, manualId)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String content) {
        try {
            int count = sweetManualSortTFCMapper.selectCount(Wrappers.lambdaUpdate(SweetManualSortTfc.class).eq(SweetManualSortTfc::getManualId, manualId));
            if (count > 0) {
                SweetManualSortTfc sweetManualSort = SweetManualSortTfc.getNew();
                sweetManualSort.setManualId(manualId);
                sweetManualSort.setShowPosition(content);
                sweetManualSort.setUpdatedAt(LocalDateTime.now());
                sweetManualSortTFCMapper.update(sweetManualSort, Wrappers.lambdaUpdate(SweetManualSortTfc.class).eq(SweetManualSortTfc::getManualId, manualId));
            } else {
                SweetManualSortTfc sweetManualSort = SweetManualSortTfc.getNew();
                sweetManualSort.setManualId(manualId);
                sweetManualSort.setShowPosition(content);
                sweetManualSort.setCreatedAt(LocalDateTime.now());
                sweetManualSortTFCMapper.insert(sweetManualSort);
            }
            redisDataUtils.deleteSortRedisData(manualId);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

}
