package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamThirdParty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "ThirdPartInfoVo", description = "用户第三方信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdamThirdPartInfoVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -3239086191919676121L;
    @ApiModelProperty(position = 11, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 12, value = "第三方ID[64]")
    private String openId;
    @ApiModelProperty(position = 13, value = "昵称[64]")
    private String nickname;
    @ApiModelProperty(position = 14, value = "头像[255]")
    private String avatar;
    @ApiModelProperty(position = 15, value = "平台类型[20]")
    private String platform;
    @ApiModelProperty(position = 16, value = "状态[1-绑定,2-解绑]")
    private Integer state;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final AdamThirdPartInfoVo obj = new AdamThirdPartInfoVo();

    public static AdamThirdPartInfoVo getNew() {
        try {
            return (AdamThirdPartInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamThirdPartInfoVo();
    }

    public AdamThirdPartInfoVo copy(AdamThirdParty source) {
        if (null == source) return this;
        this.setUid(source.getUid());
        this.setOpenId(source.getOpenId());
        this.setNickname(source.getNickname());
        this.setAvatar(source.getAvatar());
        this.setPlatform(source.getPlatform());
        this.setState(source.getState());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }
}
