package com.liquidnet.service.platform.controller.dragon;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import com.liquidnet.service.dragon.entity.DragonOrders;
import com.liquidnet.service.platform.service.dragon.IDragonOrdersService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: DragonPayController
 * @Package com.liquidnet.service.platform.controller.dragon
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/20 14:11
 */
@Api(tags = "支付-查询接口")
@RestController
@RequestMapping("dragon")
@Validated
public class DragonPayController {
    @Autowired
    IDragonOrdersService dragonOrdersService;

    @GetMapping("/getDragonOrderDto")
    @ApiOperation("订单查询")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "", example = "PAY202107131522368438531155")
    })
    @ResponseBody
    public ResponseDto<DragonOrdersDto> getDragonOrderDto(@RequestParam(value = "code") @NotNull(message = "支付编号不能为空！") String code){
        //获取用户会员信息
        LambdaQueryWrapper<DragonOrders> lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DragonOrders::getCode,code);
        DragonOrders respDto = dragonOrdersService.getOne(lambdaQueryWrapper);
        if(StringUtil.isNull(respDto)){
            return ResponseDto.failure("订单不存在！code: "+code);
        }
        DragonOrdersDto newDto = new DragonOrdersDto();
        BeanUtil.copy(respDto,newDto);
        return ResponseDto.success(newDto);
    }
}
