package com.liquidnet.service.account.funding.service.processor;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.account.common.ErrorConstants;
import com.liquidnet.service.account.common.FinConstants;
import com.liquidnet.service.account.funding.dto.FundingEditorResult;
import com.liquidnet.service.account.funding.dto.base.FundingContextParam;
import com.liquidnet.service.account.funding.entity.FinAccount;
import com.liquidnet.service.account.funding.service.FinAccountService;
import com.liquidnet.service.account.funding.service.FundingProcessorService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * FundingEditorProcessService.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/20
 */
public class FundingEditorProcessor extends FundingProcessorService {
    private static final Logger log = LoggerFactory.getLogger(FundingEditorProcessor.class);
    @Autowired
    private FinAccountService finAccountService;

    @Override
    public FundingEditorResult checkInputParams(FundingContextParam context) {
        if (StringUtils.isEmpty(context.getAccNo())) {
            return new FundingEditorResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Invalid accNo");
        }
        if ((StringUtils.isEmpty(context.getAccAlias()) || context.getAccAlias().length() > 100)
                && null == FinConstants.AccStatus.byVal(context.getAccStatus())) {
            return new FundingEditorResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Invalid accAlias or accStatus");
        }

        return new FundingEditorResult();
    }

    @Override
    public FundingEditorResult checkBussinessLogic(FundingContextParam context) {
        return new FundingEditorResult();
    }

    @Override
    public FundingEditorResult doBussiness(FundingContextParam context) {
        FinAccount updateInfo = new FinAccount();
        updateInfo.setAccNo(context.getAccNo());
        updateInfo.setAccAlias(context.getAccAlias());
        updateInfo.setAccStatus(context.getAccStatus());
        updateInfo.setUpdateTime(context.getCreateTime());
        if (finAccountService.updateAccount(updateInfo) <= 0) {
            log.warn("Update failed[Funding.account]:[{}]", JsonUtils.toJson(updateInfo));
            return new FundingEditorResult(ErrorConstants.ACCOUNT_UPDATE_ERROR_CODE, ErrorConstants.ACCOUNT_UPDATE_ERROR_DESC);
        }
        return new FundingEditorResult();
    }
}
